import java.util.ArrayList;
import java.util.List;
public class GeneEntry {
	private String name;
	private String ID = "";
	private String alias = "";
	private int start;
	private int end;
	private boolean isCovered = false;
	double fracExonsCov;
	double fracCDSCov;
	double aveCovE;
	double aveCovG;
	private int covStart = 0;
	private int covEnd = 0;
	List<ExonEntry> exons = null;
	List<CDSEntry> cds = null;
	List<mRNAEntry> mRNA = null;
	int orientation = 0;
	String chromosome = null;
	String note = null;
	private double covFrac = 0.0;
	private int strand;
	public GeneEntry(String i, int s, int e, int orient, String ch, boolean cov) {
		ID = i;
		start = s;
		end = e;
		isCovered = cov;
		exons = new ArrayList<ExonEntry>();
		cds = new ArrayList<CDSEntry>();
		mRNA = new ArrayList<mRNAEntry>();
		orientation = orient;
		chromosome = ch;
	}
	public GeneEntry(String i, int s, int e, String ch, boolean cov) {
		ID = i;
		start = s;
		end = e;
		isCovered = cov;
		exons = new ArrayList<ExonEntry>();
		cds = new ArrayList<CDSEntry>();
		mRNA = new ArrayList<mRNAEntry>();
		chromosome = ch;
	}
	public GeneEntry(String i, int s, int e) {
		ID = i;
		start = s;
		end = e;
	}
	public String getName() {
		return name;
	}
	public int getStart() {
		return start;
	}
	public int getEnd() {
		return end;
	}
	public boolean getCovered() {
		return isCovered;
	}
	public void setCovered(boolean cov) {
		isCovered = cov;
	}
	public void setCovStart(int cSt) {
		covStart = cSt;
	}
	public void setCovEnd(int cEd) {
		covEnd = cEd;
	}
	public int getCovStart() {
		return covStart;
	}
	public int getCovEnd() {
		return covEnd;
	}
	public void setName(String id) {
		ID = id;
	}
	public void setAlias(String a) {
		alias = a;
	}
	public String getAlias() {
		return alias;
	}
	public String getID() {
		return ID;
	}
	public void addExon(ExonEntry ex) {
		exons.add(ex);
	}
	public List<ExonEntry> getExons() {
		return exons;
	}
	public void setFracExonsCov(double frac) {
		fracExonsCov = frac;
	}
	public double getFracExonsCov() {
		return fracExonsCov;
	}
	public int getNumberOfExons() {
		return exons.size();
	}
	public void addCDS(CDSEntry c) {
		cds.add(c);
	}
	public List<CDSEntry> getCDS() {
		return cds;
	}
	public void setFracCDSCov(double frac) {
		fracCDSCov = frac;
	}
	public double getFracCDSCov() {
		return fracCDSCov;
	}
	public int getNumberOfCDS() {
		return cds.size();
	}
	public int getOrientation() {
		return orientation;
	}
	public void setOrientation(int o) {
		orientation = o;
	}
	public String getChromosome() {
		return chromosome;
	}
	public void setChromosme(String ch) {
		chromosome = ch;
	}
	public void addmRNA(mRNAEntry m) {
		mRNA.add(m);
	}
	public List<mRNAEntry> getmRNA() {
		return mRNA;
	}
	public void setNote(String n) {
		note = n;
	}
	public String getNote() {
		return note;
	}
	public void setAveExonsCov(double c) {
		aveCovE = c;
	}
	public double getAveExonsCov() {
		return aveCovE;
	}
	public void setAveGeneCov(double c) {
		aveCovG = c;
	}
	public double getAveGeneCov() {
		return aveCovG;
	}
	public void setExons(List<ExonEntry> exonList) {
		exons = exonList;
	}
	public void setCovFrac(double cf) {
		covFrac = cf;
	}
	public void setStrand(int s) {
		strand = s;
	}
	public int getStrand() {
		return strand;
	}
	public double getCovFrac() {
		return covFrac;
	}
}
