import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
public class ExCovUtils {
	@Deprecated
	public static List<GeneEntry> gatherGenesGff3NoExonsChr(
			BufferedReader gffReader, int chrNo, String chrName)
			throws IOException {
		String strLine;
		List<GeneEntry> genes = new ArrayList<GeneEntry>();
		GeneEntry currentGene = null;
		while ((strLine = gffReader.readLine()) != null) {
			strLine.trim();
			if (strLine.startsWith(chrName + chrNo)) {
				// split the line
				String[] line = strLine.split("\t");
				// create gene object
				if (line[2].equalsIgnoreCase("gene")) {
					// add the last gene that was worked on
					if (currentGene != null)
						genes.add(currentGene);
					// start working on a new GeneEntry
					// get gene name and ID
					String[] geneName_ID = line[8].split(";");
					// store ID
					String geneIDFull = geneName_ID[0];
					String geneID = geneIDFull.substring(geneIDFull
							.indexOf('=') + 1);
					// store Name
					String geneNameFull = geneName_ID[1];
					String geneName = geneNameFull.substring(geneNameFull
							.indexOf('=') + 1);
					// remember that they are indexed form 1
					String chromo = line[0].trim();
					Integer geneStart = Integer.parseInt(line[3]);
					Integer geneEnd = Integer.parseInt(line[4]);
					String orient = line[6];
					int or;
					if (orient.equals("+")) {
						or = 1;
					}
					else {
						if (orient.equals("-")) {
							or = -1;
						}
						else {
							or = 0;
						}
					}
					currentGene = new GeneEntry(geneID, geneStart, geneEnd, or,
							chromo, false);
					currentGene.setName(geneID);
				}
			}
		}
		// add the last gene
		if (currentGene != null)
			genes.add(currentGene);
		return genes;
	}
	public static List<GeneEntry> gatherGenesGff3All(BufferedReader gffReader)
			throws IOException {
		String strLine;
		List<GeneEntry> genes = new ArrayList<GeneEntry>();
		GeneEntry currentGene = null;
		while ((strLine = gffReader.readLine()) != null) {
			strLine.trim();
			// split the line
			if (strLine.startsWith("#") == false) {
				String[] line = strLine.split("\t");
				// create gene object
				if (line[2].equalsIgnoreCase("gene")) {
					// add the last gene that was worked on
					if (currentGene != null) {
						// getting exons, merging exons, putting them back in
						List<ExonEntry> exL = currentGene.getExons();
					    List <ExonEntry> exLm = mergeExons(exL);
					    currentGene.setExons(exLm);
						genes.add(currentGene);
					}
					// start working on a new GeneEntry
					// get gene name and ID
					String[] geneName_ID = line[8].split(";");
					// store ID, name, alias and
					String geneID = "";
					String geneName = "";
					String geneAlias = "";
					String note = "";
					for (String s : geneName_ID) {
						if (s.trim().startsWith("ID=")) {
							geneID = s.substring(s.indexOf('=') + 1);
						}
						if (s.trim().startsWith("Name=")) {
							geneName = s.substring(s.indexOf('=') + 1);
						}
						if (s.trim().startsWith("Alias=")) {
							geneAlias = s.substring(s.indexOf('=') + 1);
						}
						if (s.trim().startsWith("Note=")) {
							note = s.substring(s.indexOf('=') + 1);
						}
					}
					// remember that they are indexed form 1
					String chromo = line[0].trim();
					Integer geneStart = Integer.parseInt(line[3]);
					Integer geneEnd = Integer.parseInt(line[4]);
					String orient = line[6];
					int or;
					if (orient.equals("+")) {
						or = 1;
					}
					else {
						if (orient.equals("-")) {
							or = -1;
						}
						else {
							or = 0;
						}
					}
					currentGene = new GeneEntry(geneID, geneStart, geneEnd, or,
							chromo, false);
					currentGene.setName(geneID);
					currentGene.setAlias(geneAlias);
					currentGene.setNote(note);
				}
				else {
					if (line[2].equalsIgnoreCase("mRNA") && currentGene != null) {
						String orient = line[6];
						int or;
						if (orient.equals("+")) {
							or = 1;
						}
						else {
							if (orient.equals("-")) {
								or = -1;
							}
							else {
								or = 0;
							}
						}
						// gather the information to create mRNA
						// will need something to add exon/CDS orintation to
						// mRNA objects, do not need it right now, but probably
						// will
						String[] mName_ID = line[8].split(";");
						// store ID, name, alias and
						String mID = "";
						String mName = "";
						String mAlias = "";
						for (String s : mName_ID) {
							if (s.trim().startsWith("ID=")) {
								mID = s.substring(s.indexOf('=') + 1);
							}
							if (s.trim().startsWith("Name=")) {
								mName = s.substring(s.indexOf('=') + 1);
							}
							if (s.trim().startsWith("Alias=")) {
								mAlias = s.substring(s.indexOf('=') + 1);
							}
						}
						String chromo = line[0].trim();
						Integer mRNAstart = Integer.parseInt(line[3]);
						Integer mRNAend = Integer.parseInt(line[4]);
						mRNAEntry m = new mRNAEntry(mID, mRNAstart, mRNAend, or);
						m.setName(mName);
						m.setAlias(mAlias);
						m.setChromosome(chromo);
						currentGene.addmRNA(m);
					}
					if (line[2].equalsIgnoreCase("exon") && currentGene != null) {
						String[] exonInfo = line[8].split(";");
						String exonIDFull = exonInfo[0];
						String exonID = exonIDFull.substring(exonIDFull
								.indexOf('=') + 1);
						Integer exonStart = Integer.parseInt(line[3]);
						Integer exonEnd = Integer.parseInt(line[4]);
						ExonEntry currentExon = new ExonEntry(exonID,
								exonStart, exonEnd);
						if (!currentGene.getExons().contains(currentExon)) {
							currentGene.addExon(currentExon);
						}
					}
				}
			}
		}
		// add the last gene
		if (currentGene != null) {
			// getting exons, merging exons, putting them back in
			List<ExonEntry> exL = currentGene.getExons();
		    List <ExonEntry> exLm = mergeExons(exL);
		    currentGene.setExons(exLm);
			genes.add(currentGene);
		}
		return genes;
	}
	@Deprecated
	public static List<GeneEntry> gatherGenesGff3AllSNAP(
			BufferedReader gffReader) throws IOException {
		String strLine;
		List<GeneEntry> genes = new ArrayList<GeneEntry>();
		String currentGene = null;
		int geneStart = 0;
		String geneID = "";
		List<ExonEntry> exons = null;
		while ((strLine = gffReader.readLine()) != null) {
			strLine.trim();
			// split the line
			if (strLine.startsWith("#") == false) {
				String[] line = strLine.split("\t");
				// create gene object
				if (line[2].equalsIgnoreCase("Esngl")) {
					int st = Integer.parseInt(line[3].trim());
					int end = Integer.parseInt(line[4].trim());
					String name = line[8].trim();
					String strand = line[6].trim();
					int s = 0;
					if (strand.equalsIgnoreCase("+")) {
						s = 1;
					}
					if (strand.equalsIgnoreCase("-")) {
						s = -1;
					}
					String gID = name;
					GeneEntry esngl = new GeneEntry(gID, st, end);
					esngl.setStrand(s);
					esngl.setChromosme(line[0].trim());
					List<ExonEntry> ex = new ArrayList<ExonEntry>();
					ex.add(new ExonEntry(name, st, end));
					esngl.setExons(ex);
					genes.add(esngl);
				}
				else {
					if (line[2].equalsIgnoreCase("Einit")) {
						geneStart = Integer.parseInt(line[3].trim());
						// taking end of Einit for the negative strand genes
						if (line[6].trim().equalsIgnoreCase("-")) {
							geneStart = Integer.parseInt(line[4].trim());
						}
						geneID = line[8];
						exons = new ArrayList<ExonEntry>();
						currentGene = geneID;
						int st = Integer.parseInt(line[3].trim());
						int end = Integer.parseInt(line[4].trim());
						String name = line[8].trim();
						exons.add(new ExonEntry(name, st, end));
					}
					else {
						if (line[2].equalsIgnoreCase("exon")
								&& currentGene != null) {
							int st = Integer.parseInt(line[3].trim());
							int end = Integer.parseInt(line[4].trim());
							String name = line[8].trim();
							exons.add(new ExonEntry(name, st, end));
						}
						else {
							if (line[2].equalsIgnoreCase("Eterm")
									&& currentGene != null) {
								int st = Integer.parseInt(line[3].trim());
								int end = Integer.parseInt(line[4].trim());
								int geneEnd = Integer.parseInt(line[4].trim());
								if (line[6].trim().equalsIgnoreCase("-")) {
									geneEnd = Integer.parseInt(line[3].trim());
								}
								String name = line[8].trim();
								exons.add(new ExonEntry(name, st, end));
								String chrom = line[0].trim();
								GeneEntry g = null;
								String strand = line[6].trim();
								int s = 0;
								if (strand.equalsIgnoreCase("+")) {
									s = 1;
								}
								if (strand.equalsIgnoreCase("-")) {
									s = -1;
								}
								if (geneEnd < geneStart) {
									g = new GeneEntry(geneID, geneEnd,
											geneStart);
								}
								else {
									g = new GeneEntry(geneID, geneStart, end);
								}
								g.setChromosme(chrom);
								g.setExons(exons);
								g.setStrand(s);
								genes.add(g);
								if (g.getStart() == 0 && g.getEnd() == 2119471) {
									System.out.println(strLine);
								}
								geneStart = 0;
								geneID = "";
								// null is here to protect from weird genes, no
								// initiation
								currentGene = null;
							}
						}
					}
				}
			}
		}
		return genes;
	}
	// remeber exons are overlapping; remove the overlapping bits before
	// proceeding with checking
	// TODO !!!!!!!!!!!!!!!! remove exon overlaps
	//done - implemented exon entry comparator and merge exons
	public static void checkGenesUseExons(List<Integer> coverage,
			List<GeneEntry> geneList, int neededCov) {
		System.out.println("Gene list size is: " + geneList.size());
		int exonsLength;
		int exonsPosCovered;
		int totCoverage;
		int genePosCovered;
		int geneLength;
		int totCoverageG;
		for (GeneEntry g : geneList) {
			genePosCovered = 0;
			geneLength = 0;
			totCoverageG = 0;
			for (int j = g.getStart() - 1; j < g.getEnd(); j++) {
				if (coverage.get(j) >= neededCov) {
					genePosCovered++;
					totCoverageG=totCoverageG+coverage.get(j);
				}
				geneLength++;
			}
			double covF = (double) genePosCovered / (double) geneLength;
			g.setCovFrac(covF);
			double aveCovG;
			if (genePosCovered!=0) {
			aveCovG=(double)totCoverageG/(double)genePosCovered;
			}
			else {
				aveCovG=0.0;
			}
			g.setAveGeneCov(aveCovG);
			exonsLength = 0;
			exonsPosCovered = 0;
			totCoverage = 0;
			if (g.getExons() != null && g.getExons().size() != 0) {
				List<ExonEntry> geneExons = g.getExons();
				Collections.sort(geneExons, new ExonEntryComparator());
				for (ExonEntry ex : geneExons) {
					// have to move all by one indexing from 0, positions from 1
					// for now only consider the positions over the desired
					// coverage is the average coverage count
					int exonSize = 0;
					int exonCov = 0;
					int exonCovTot=0;
					for (int i = ex.getStart() - 1; i < ex.getEnd(); i++) {
						if (coverage.get(i) >= neededCov) {
							exonsPosCovered++;
							totCoverage = totCoverage + coverage.get(i);
							exonCovTot=exonCovTot+coverage.get(i);
							exonCov++;
						}
						exonsLength++;
						exonSize++;
					}
					ex.setFracCov((double) exonCov / (double) exonSize);
					ex.setAveCov((double)exonCovTot / (double) exonSize);
				}
				if (exonsLength != 0) {
					double covFrac = (double) exonsPosCovered
							/ (double) exonsLength;
					if (exonsPosCovered == 0) {
						g.setAveExonsCov(0.0);
					}
					else {
						double aveCov = (double) totCoverage
								/ (double) exonsPosCovered;
						g.setAveExonsCov(aveCov);
					}
					g.setFracExonsCov(covFrac);
				}
			}
		}
	}
	@Deprecated
	public static void checkGenesUseCDS(List<Integer> coverage,
			List<GeneEntry> geneList, int neededCov, double fracExonCov) {
		System.out.println("Gene list size is: " + geneList.size());
		int CDSLength;
		int CDSPosCovered;
		for (GeneEntry g : geneList) {
			CDSLength = 0;
			CDSPosCovered = 0;
			if (g.getCDS() != null && g.getCDS().size() != 0) {
				List<CDSEntry> cdsOverlap = g.getCDS();
				for (CDSEntry c : cdsOverlap) {
					// have to move all by one indexing from 0, positions from 1
					for (int i = c.getStart() - 1; i < c.getEnd(); i++) {
						if (coverage.get(i) >= neededCov) {
							CDSPosCovered++;
						}
						CDSLength++;
					}
				}
				for (CDSEntry c : cdsOverlap) {
					System.out.println(c.getID() + " " + c.getStart() + " "
							+ c.getEnd());
				}
				System.out.println(CDSLength);
				System.out.println(CDSPosCovered);
				if (CDSLength != 0) {
					double covFrac = (double) CDSPosCovered
							/ (double) CDSLength;
					g.setFracCDSCov(covFrac);
					System.out.println(covFrac);
					if (covFrac >= fracExonCov) {
						g.setCovered(true);
					}
				}
			}
		}
	}
	@Deprecated
	public static void checkGenes(List<Integer> coverage,
			List<GeneEntry> geneList, int neededCov) {
		System.out.println("Gene list size is: " + geneList.size());
		for (GeneEntry g : geneList) {
			int start = g.getStart();
			int end = g.getEnd();
			// have to move all by one indexing from 0, positions from 1
			int covered = 0;
			for (int i = start - 1; i < end; i++) {
				if (coverage.get(i) > 200) {
					covered++;
				}
				else {
					covered = 0;
				}
				if (covered == neededCov) {
					g.setCovered(true);
					g.setCovStart(i - neededCov);
					break;
				}
			}
		}
	}
	public static List<GeneEntry> getAllGenesGff3(String pathToGff,
			boolean isSNAP) throws IOException {
		FileInputStream g1 = new FileInputStream(pathToGff);
		DataInputStream g2 = new DataInputStream(g1);
		BufferedReader g3 = new BufferedReader(new InputStreamReader(g2));
		if (isSNAP) {
			return ExCovUtils.gatherGenesGff3AllSNAP(g3);
		}
		else {
			return ExCovUtils.gatherGenesGff3All(g3);
		}
	}
	public static Map<String, List<GeneEntry>> genesListToMap(
			List<GeneEntry> genes) {
		Map<String, List<GeneEntry>> genesInChr = new LinkedHashMap<String, List<GeneEntry>>();
		for (GeneEntry g : genes) {
			if (genesInChr.containsKey(g.getChromosome())) {
				genesInChr.get(g.getChromosome()).add(g);
			}
			else {
				genesInChr.put(g.getChromosome(), new ArrayList<GeneEntry>());
				genesInChr.get(g.getChromosome()).add(g);
			}
		}
		return genesInChr;
	}
	public static List<ExonEntry> mergeExons (List<ExonEntry> eList) {
		List<ExonEntry> eListM = new ArrayList<ExonEntry>();
		Collections.sort(eList, new ExonEntryComparator());
		eListM.add(0, eList.get(0));
		for (int i = 1; i < eList.size(); i++) {
			if (eList.get(i).getStart()
					<= eListM.get(eListM.size() - 1).getEnd()) {
				ExonEntry curr = eListM.get(eListM.size() - 1);
				if(eList.get(i).getEnd() > curr.getEnd()) {
				curr.setEnd(eList.get(i).getEnd());
				}
				curr.setID(curr.getID() + "_" + eList.get(i).getID());
			} else {
				eListM.add(eList.get(i));
			}
		}
		return eListM;
	}
}
