##======================================================== 
# Main R progam 
# graph_circles.R 
##======================================================== 
####################GPLv2+###############################
##-------------------------------------------------------- 
# Author:       Agnieszka Golicz 
#               The University of Queensland
#               Applied Bioinformatics Group
# created:      
# mofified:     June 18th, 2014
##-------------------------------------------------------- 

##--------------------------------------------------------
# Calling libraries
##--------------------------------------------------------
# Install package if necessary
list.of.packages <- c("ggplot2")
new.packages <- list.of.packages[!(list.of.packages %in% installed.packages()[,"Package"])]
if(length(new.packages)) install.packages(new.packages)
library(ggplot2)

options(warn=-1)
#update Bioconductor
source("http://www.bioconductor.org/biocLite.R")
biocLite()

#call library ggbio
library(ggbio)
#call library GenomicRanges
library(GenomicRanges)

##--------------------------------------------------------
# This R script makes a circular plot for illustrating 
# lost genes
##--------------------------------------------------------
PlotCircle <- function(chrinfo, chrnames, files, outFOLD, nameout){
	library(ggbio)
	library(GenomicRanges)
	
	path <- getwd()
	dataChr  <- read.table(chrinfo,header=T,sep=",",stringsAsFactors=FALSE)
	chrOrder <- read.table(chrnames,header=T,sep=",",stringsAsFactors=FALSE)
	filesL   <- strsplit(files,",")[[1]]
	dataChrM <- merge(dataChr, chrOrder, by.x = "chr", by.y = "chr")
	dataChrM$chr <- dataChrM$no
	dataChrM$no  <- NULL
	dataChrMS    <- dataChrM[order(dataChrM$chr),]
	chrs    <- with(dataChrMS, GRanges(chr, IRanges(start, end)))
	seqlens <- setNames(dataChrMS$len, as.character(dataChrMS$chr))
	seqlengths(chrs) <- seqlens
	p <- ggbio()
	for (i in filesL) {
        	t <- read.table(i,header=T,sep=",",stringsAsFactors=FALSE)
        	tM <- merge(t, chrOrder, by.x = "chr", by.y = "chr")
	        tM$chr <- tM$no
        	tM$no <- NULL
	        tMS <- tM[order(tM$chr),]
        	lost <- with(tMS, GRanges(chr, IRanges(start, end), id=id))
	        seqlevels(lost) <- seqlevels(chrs)
	        seqlengths(lost) <- seqlengths(chrs)
	        lost <- keepSeqlevels(lost,as.character(dataChrMS$chr))
	        p <- p + circle(lost, geom = "rect", color = "steelblue")
	}

	p <- p + circle(chrs, geom = "ideo", fill = "gray70")
	p <- p + circle(chrs, geom = "scale", size = 2)
	p <- p + circle(chrs, geom = "text", aes(label = seqnames), vjust = -0.5, size = 3)
	
	setwd(outFOLD)
	ggsave(file=nameout, width=10, height=6, dpi=1200)
	setwd(path)
}

##--------------------------------------------------------
# Input parameters:                        
# 1. file with chromosome info                  
# 2. file with chromosome names assigned to order  
# 3. comma sparated list of files with results    
# 4. Output path
# 5. name of the outout file (.jpeg, .png)  
##--------------------------------------------------------
args <- commandArgs(trailingOnly = TRUE)
if (length(args) < 5) {
	stop("Please provide five arguments. 1. file with chromosome info 2. file with chromosome names assigned to order 3.comma sparated list of files with results 4. Output path 5. name of the outout file (.jpeg, .png)")
}
chrinfo		<- args[1]
print(paste("Chromosome info: ", chrinfo, sep=""))
chrnames	<- args[2]
print(paste("Chromosome names: ", chrnames, sep=""))
files		<- args[3]
print(paste("Files: ", files, sep=""))
outFOLD         <- args[4]
print(paste("Output path: ", outFOLD  , sep=""))
nameout		<- args[5]
print(paste("Output name: ", nameout  , sep=""))


PlotCircle(chrinfo, chrnames, files, outFOLD, nameout)

