#======================================================== 
# Main R progam 
# graph_chromosomes.R 
##======================================================== 
####################GPLv2+################################
##-------------------------------------------------------- 
# Author:	Agnieszka Golicz 
# 		The University of Queensland
# 		Applied Bioinformatics Group
# created:      
# mofified:     June 18th, 2014
##-------------------------------------------------------- 


##--------------------------------------------------------
# This R script makes a plot for each of the chromosomes
# 
##--------------------------------------------------------

##--------------------------------------------------------
# PlotExcov is a function for plotting the genes per 
# chromosome with their corresponding cutoffs
#    FOL, folder path where the chr.graph files are located
#    f, plots one file at the time
#    name, string name of the chromosome to plot
#    lC, cutoff line 
#    outPath, the path of the folder to save images
# 
##--------------------------------------------------------
PlotExcov <- function(FOL, f, name, lC, outPath){
        library(ggplot2)
        path <- getwd()
  #      setwd(FOL)
        theme_set(theme_bw(24))
        excov <- read.csv(f, head=TRUE, sep=",")
        excov$frac_exons_covered <- as.numeric(as.character(excov$frac_exons_covered))
        excov$start_position <- as.numeric(as.character(excov$start_position))
        p <- qplot(start_position, frac_exons_covered , data=excov, colour=cov_cat, 
		xlab = "Chromosome Position", ylab = "Fraction of exons covered", 
		main = paste("Exon coverage ", name, sep="")) + 
		theme(panel.border = element_rect(colour = "black"),
			plot.title = element_text(size=16, vjust=0.8, hjust=0.5),
                	axis.text  = element_text(size=10, vjust=0.4, hjust=0.5),
			axis.title = element_text(size=14, vjust=0.3, hjust=0.5)) +
		guides(colour = guide_legend(override.aes = list(size=3,linetype=0))) +
		scale_y_continuous(limits=c(0,1))
        if(lC!=0.0) {
        	p <- p + geom_hline(yintercept=lC, colour="red")
	}
	setwd(outPath)
	ggsave(file=paste(name,".png", sep=""), width=10, height=6, dpi=200)
        setwd(path)
}

##--------------------------------------------------------
# Calling the method:
# Three command-line arguments are taken
##--------------------------------------------------------
args <- commandArgs(trailingOnly = TRUE)
if (length(args) < 3) {
        stop("Please provide three arguments. 1. Path to files 2. Cutoff 3. Output folder")
}
# 1. Directory where files results are located
FOL <- args[1]
print(paste("Path to files: ", FOL, sep=""))

# 2. Cutoff for gene loss coverage in the range of [0,1]
lostCT <- args[2]
print(paste("Cutoff used: ", lostCT, sep=""))
# 3. outPath, folder where to save the images
outPath <- args[3]
print(paste("Output Folder: ", outPath, sep=""))

##--------------------------------------------------------
# Install package if necessary
list.of.packages <- c("ggplot2")
new.packages <- list.of.packages[!(list.of.packages %in% installed.packages()[,"Package"])]
if(length(new.packages)) install.packages(new.packages)
##--------------------------------------------------------

##--------------------------------------------------------
#read the files in FOL with the names and call the funcion to plot
##--------------------------------------------------------
path <- getwd()
setwd(FOL)
files <- list.files()
for (i in 1:length(files)){
	f <- files[i]
	parts <- unlist(strsplit(f, "\\.")) 
	#if(length(grep(".excov", f, fixed=TRUE)) > 0){	
	if(length(grep(".excov", f, fixed=TRUE)) > 0){
		print(f)
		name <- parts[1]
		print(name)
		PlotExcov(FOL,f, name, as.double(lostCT), outPath)
	}
}
setwd(path)
	
