/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.picard.util.Interval;
import net.sf.picard.util.IntervalList;
import net.sf.picard.util.SamLocusIterator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMSequenceDictionary;

public class ExonCoverage5 {
    private static String bamPathKey = "bamPath";
    private static String gffKey = "gffFile";
    private static String outPathKey = "outDirPath";
    private static String separator = "=";
    private static String minCovKey = "minCov";
    private static String chromListKey = "chromosomeList";
    private static String bamListKey = "bamFileList";
    private static String outFormatKey = "extendedFmt";
    private static String lostCutoffKey = "lostCutoff";
    private static String covCatKey = "covCats";
    private static String help = "Command line options:\nRequired:\nbamPath - path to your bam file/files, has to end with \u201c/\u201d or \u201c\\\u201d bamPath=/home/my_bams/\nbamFileList \u2013 a single .bam file or a comma separated list, only file names, bam and corresponding .bai files have to be in a directory provided in bamPath bamFileList=bam1.bam,bam2.bam\ngffFile \u2013 location of gff3 file gffFile=/home/my_gffs/annot.gff3\noutDirPath \u2013 location output directory, has to end with \u201c/\u201d or \u201c\\\u201d outDirPath=/home/my_results\nOptional\nminCov \u2013 minimal coverage threshold to consider position covered [minCov=1]\nchromosomeList \u2013 comma separated list of chromosomes to be used for analysis, use \u201call\u201d, for all chromosomes [chromosomeList=all]\nlostCutoff \u2013 coverage cutoff to consider gene as lost for calculating stats [lostCutoff=0.0]\ncovCats \u2013 coverage categories for visualization [cavCats=0,10,20,30,40,70]\nextendedFmt \u2013 used extended format, additional info included in output files [regular format] \n\nPlease make sure that all your supplied paths end with \u201c/\u201d or \u201c\\\u201d\nIf memory consumption is a problem please consider splitting your .bam files\nSample commands:\njava -Xmx4g -jar SGSGeneLoss.jar bamPath=/home/uqagnieszka/bams/ bamFileList=arabidopsis.sorted.bam gffFile=/home/gff_files/Athaliana_167_gene_exons.gff3 outDirPath=/home/uqagnieszka/results/ chromosomeList=all\njava -Xmx4g -jar SGSGeneLoss.jar bamPath=/home/uqagnieszka/bams/ bamFileList=arabidopsis.sorted.bam, arabidopsis2.sorted.bam gffFile=/home/gff_files/Athaliana_167_gene_exons.gff3 outDirPath=/home/uqagnieszka/results/ chromosomeList=Chr1,Chr2 minCov=2 lostCutoff=0.05 covCats=0,2,5,10,20 extendedFmt\nTo see help run: java -Xmx4g -jar SGSGeneLoss.jar help";

    public static String getHelp(String[] cmd) {
        String[] stringArray = cmd;
        int n = cmd.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c.equals("help")) {
                return help;
            }
            ++n2;
        }
        return null;
    }

    public static boolean getOutFmt(String[] cmd) {
        String[] stringArray = cmd;
        int n = cmd.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c.equals("extendedFmt")) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getBamFileList(String[] cmd) {
        String[] stringArray = cmd;
        int n = cmd.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c.startsWith(String.valueOf(bamListKey) + separator)) {
                System.out.println(c.substring(c.indexOf(separator) + 1));
                return c.substring(c.indexOf(separator) + 1);
            }
            ++n2;
        }
        return null;
    }

    public static String getChromList(String[] cmd) {
        String[] stringArray = cmd;
        int n = cmd.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c.startsWith(String.valueOf(chromListKey) + separator)) {
                System.out.println(c.substring(c.indexOf(separator) + 1));
                return c.substring(c.indexOf(separator) + 1);
            }
            ++n2;
        }
        return null;
    }

    public static String getCovCat(String[] cmd) {
        String[] stringArray = cmd;
        int n = cmd.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c.startsWith(String.valueOf(covCatKey) + separator)) {
                System.out.println(c.substring(c.indexOf(separator) + 1));
                return c.substring(c.indexOf(separator) + 1);
            }
            ++n2;
        }
        return null;
    }

    public static String getBamPath(String[] cmd) {
        String[] stringArray = cmd;
        int n = cmd.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c.startsWith(String.valueOf(bamPathKey) + separator)) {
                System.out.println(c.substring(c.indexOf(separator) + 1));
                return c.substring(c.indexOf(separator) + 1);
            }
            ++n2;
        }
        return null;
    }

    public static Integer getMinCov(String[] cmd) {
        Integer minCov = null;
        String[] stringArray = cmd;
        int n = cmd.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c.startsWith(String.valueOf(minCovKey) + separator)) {
                try {
                    minCov = Integer.parseInt(c.substring(c.indexOf(separator) + 1));
                }
                catch (NumberFormatException e) {
                    return null;
                }
                System.out.println(minCov);
                return minCov;
            }
            ++n2;
        }
        return null;
    }

    public static Double getLostCutoff(String[] cmd) {
        Double lCutoff = null;
        String[] stringArray = cmd;
        int n = cmd.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c.startsWith(String.valueOf(lostCutoffKey) + separator)) {
                try {
                    lCutoff = Double.parseDouble(c.substring(c.indexOf(separator) + 1));
                }
                catch (NumberFormatException e) {
                    return null;
                }
                System.out.println(lCutoff);
                return lCutoff;
            }
            ++n2;
        }
        return null;
    }

    public static String getOutDirPath(String[] cmd) {
        String[] stringArray = cmd;
        int n = cmd.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c.startsWith(String.valueOf(outPathKey) + separator)) {
                System.out.println(c.substring(c.indexOf(separator) + 1));
                return c.substring(c.indexOf(separator) + 1);
            }
            ++n2;
        }
        return null;
    }

    public static String getGffFile(String[] cmd) {
        String[] stringArray = cmd;
        int n = cmd.length;
        int n2 = 0;
        while (n2 < n) {
            String c = stringArray[n2];
            if (c.startsWith(String.valueOf(gffKey) + separator)) {
                System.out.println(c.substring(c.indexOf(separator) + 1));
                return c.substring(c.indexOf(separator) + 1);
            }
            ++n2;
        }
        return null;
    }

    public static void main(String[] args) {
        String[] chrs;
        String chromList;
        String outPath;
        String gffPath;
        Double lostCT;
        Integer minCov;
        String[] bamFiles;
        String bamFilesS;
        String bamFilesPath;
        String h = ExonCoverage5.getHelp(args);
        if (h != null) {
            System.out.println(help);
            System.exit(1);
        }
        if (args.length < 4) {
            System.out.println(help);
            System.exit(1);
        }
        if ((bamFilesPath = ExonCoverage5.getBamPath(args)) == null) {
            System.out.println("Path to bam files not specified.");
            System.out.println(help);
            System.exit(1);
        }
        if ((bamFilesS = ExonCoverage5.getBamFileList(args)) == null) {
            System.out.println("List of .bam files not specified.");
            System.out.println(help);
            System.exit(1);
        }
        if ((bamFiles = bamFilesS.split(",")).length == 0) {
            System.out.println("List of .bam files not specified.");
            System.out.println(help);
            System.exit(1);
        }
        if ((minCov = ExonCoverage5.getMinCov(args)) == null) {
            System.out.println("Minimum coverage not specified or not an integer.");
            minCov = 1;
            System.out.println("Using default value: " + minCov);
        }
        if ((lostCT = ExonCoverage5.getLostCutoff(args)) == null) {
            System.out.println("Lost gene cufoff not specified or not a value [0,1].");
            lostCT = 0.0;
            System.out.println("Using default value: " + lostCT);
        }
        if ((gffPath = ExonCoverage5.getGffFile(args)) == null) {
            System.out.println("Gff3 file not specified.");
            System.out.println(help);
            System.exit(1);
        }
        if ((outPath = ExonCoverage5.getOutDirPath(args)) == null) {
            System.out.println("Path to the output folder not specified.");
            System.out.println(help);
            System.exit(1);
        }
        if ((chromList = ExonCoverage5.getChromList(args).trim()) == null) {
            System.out.println("Chromosome list not specified.");
            chromList = "all";
            System.out.println("Using default value: " + chromList);
        }
        if ((chrs = chromList.split(",")).length == 0) {
            System.out.println("Chromosome list empty.");
            System.out.println(help);
            System.exit(1);
        }
        ArrayList<Integer> covCatList = new ArrayList<Integer>();
        String covCatS = ExonCoverage5.getCovCat(args);
        String covCatSdef = "0,10,20,40,70";
        if (covCatS == null || covCatS.split(",").length < 2) {
            System.out.println("List of coverage categories list not specified, or samller than two.");
            covCatList.add(0);
            covCatList.add(10);
            covCatList.add(20);
            covCatList.add(40);
            covCatList.add(70);
            System.out.println("Using default value: " + covCatSdef);
        } else {
            String[] stringArray = covCatS.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                try {
                    int cat = Integer.parseInt(s);
                    covCatList.add(cat);
                }
                catch (Exception e) {
                    System.out.println("One of the categories not an integer");
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        Boolean outFmtE = ExonCoverage5.getOutFmt(args);
        int noGenesAll = 0;
        int noGenesPresent = 0;
        int noGenesLost = 0;
        int totLenAll = 0;
        int totLenPresent = 0;
        int totLenLost = 0;
        int totELenAll = 0;
        int totELenPresent = 0;
        int totELenLost = 0;
        int totENumAll = 0;
        int totENumPresent = 0;
        int totENumLost = 0;
        ArrayList<String> lostList = new ArrayList<String>();
        ArrayList<String> chrInfList = new ArrayList<String>();
        List<GeneEntry> geneList = null;
        try {
            geneList = ExCovUtils.getAllGenesGff3(gffPath, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Map<String, List<GeneEntry>> genesInChrs = ExCovUtils.genesListToMap(geneList);
        if (chrs[0].equalsIgnoreCase("all")) {
            SAMFileReader samR = null;
            try {
                samR = ExonCoverage5.getBamFileReader(bamFilesPath.trim() + bamFiles[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            SAMFileHeader headS = samR.getFileHeader();
            SAMSequenceDictionary dictS = headS.getSequenceDictionary();
            List seqsR = dictS.getSequences();
            String[] chrArr = new String[seqsR.size()];
            int cnt = 0;
            for (Object s : seqsR) {
                chrArr[cnt] = s.getSequenceName();
                ++cnt;
            }
            samR.close();
            chrs = chrArr;
        }
        String[] stringArray = chrs;
        int dictS = chrs.length;
        int n = 0;
        while (n < dictS) {
            String s = stringArray[n];
            if (genesInChrs.get(s) == null) {
                System.out.println("Chromosome: " + s + " has no genes.");
            } else {
                List<Integer> finalCoverage = ExonCoverage5.getCoverage(bamFiles, bamFilesPath, s, chrInfList);
                ExCovUtils.checkGenesUseExons(finalCoverage, genesInChrs.get(s), minCov);
            }
            ++n;
        }
        stringArray = chrs;
        dictS = chrs.length;
        n = 0;
        while (n < dictS) {
            String ch = stringArray[n];
            if (genesInChrs.get(ch) != null) {
                PrintWriter print = null;
                try {
                    print = new PrintWriter(new FileOutputStream(String.valueOf(outPath) + ch + ".excov", false));
                    if (outFmtE.booleanValue()) {
                        print.println("chromosome,ID,is_lost,start_position,end_postion,frac_exons_covered,frac_gene_covered,ave_cov_depth_exons,cov_cat,ave_cove_depth_gene,all_exons_ids,all_exons_length,all_exons_frac_covered,all_exons_cov_depth,notes");
                    } else {
                        print.println("chromosome,ID,is_lost,start_position,end_postion,frac_exons_covered,frac_gene_covered,ave_cov_depth_exons,cov_cat,ave_cove_depth_gene");
                    }
                    for (GeneEntry gene : genesInChrs.get(ch)) {
                        boolean isLost;
                        String exLen = ExonCoverage5.exonsLengthsToString(gene.getExons());
                        int totELen = ExonCoverage5.exonsTotLen(gene.getExons());
                        int totGLen = gene.getEnd() - gene.getStart() + 1;
                        String exIDs = ExonCoverage5.exonsIDsToString(gene.getExons());
                        String exCovH = ExonCoverage5.exonsCovHorToString(gene.getExons());
                        String exCovV = ExonCoverage5.exonsCovVerToString(gene.getExons());
                        String covClass = "";
                        double cov = gene.getAveExonsCov();
                        double covH = gene.getFracExonsCov();
                        ++noGenesAll;
                        totLenAll += totGLen;
                        totELenAll += totELen;
                        totENumAll += gene.getExons().size();
                        String lost = "";
                        if (covH <= lostCT) {
                            isLost = true;
                            ++noGenesLost;
                            totLenLost += totGLen;
                            totELenLost += totELen;
                            totENumLost += gene.getExons().size();
                        } else {
                            isLost = false;
                            ++noGenesPresent;
                            totLenPresent += totGLen;
                            totELenPresent += totELen;
                            totENumPresent += gene.getExons().size();
                        }
                        lost = isLost ? "LOST" : "PRESENT";
                        int catNum = covCatList.size();
                        int first = (Integer)covCatList.get(0);
                        int last = (Integer)covCatList.get(catNum - 1);
                        if (cov <= (double)first) {
                            covClass = first == 0 ? "not_covered" : "<=" + first;
                        } else if (cov > (double)last) {
                            covClass = String.valueOf(last) + "+";
                        } else {
                            int i = 0;
                            while (i < catNum) {
                                int j = i + 1;
                                if (cov > (double)((Integer)covCatList.get(i)).intValue() && cov <= (double)((Integer)covCatList.get(j)).intValue()) {
                                    covClass = covCatList.get(i) + "-" + covCatList.get(j);
                                }
                                ++i;
                            }
                        }
                        if (isLost) {
                            String printStr = String.valueOf(ch) + "," + gene.getID() + "," + gene.getStart() + "," + gene.getStart();
                            lostList.add(printStr);
                        }
                        if (outFmtE.booleanValue()) {
                            print.println(String.valueOf(ch) + "," + gene.getID() + "," + lost + "," + gene.getStart() + "," + gene.getEnd() + "," + gene.getFracExonsCov() + "," + gene.getCovFrac() + "," + gene.getAveExonsCov() + "," + covClass + "," + gene.getAveGeneCov() + "," + gene.getNumberOfExons() + "," + exIDs + "," + exLen + "," + exCovH + "," + exCovV + "," + gene.getNote());
                            continue;
                        }
                        print.println(String.valueOf(ch) + "," + gene.getID() + "," + lost + "," + gene.getStart() + "," + gene.getEnd() + "," + gene.getFracExonsCov() + "," + gene.getCovFrac() + "," + gene.getAveExonsCov() + "," + covClass + "," + gene.getAveGeneCov());
                    }
                    print.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n;
        }
        double aveLenAll = (double)totLenAll / (double)noGenesAll;
        double aveLenPresent = (double)totLenPresent / (double)noGenesPresent;
        double aveLenLost = (double)totLenLost / (double)noGenesLost;
        double aveELenAll = (double)totELenAll / (double)totENumAll;
        double aveELenPresent = (double)totELenPresent / (double)totENumPresent;
        double aveELenLost = (double)totELenLost / (double)totENumLost;
        double aveENumAll = (double)totENumAll / (double)noGenesAll;
        double aveENumPresent = (double)totENumPresent / (double)noGenesPresent;
        double aveENumLost = (double)totENumLost / (double)noGenesLost;
        PrintWriter printS = null;
        try {
            printS = new PrintWriter(new FileOutputStream(String.valueOf(outPath) + "stats.txt", false));
            printS.println("Bam path: " + bamFilesPath);
            printS.println("Bam files: " + bamFilesS);
            printS.println("Gff path: " + gffPath);
            printS.println("Chromosome list: " + chromList);
            printS.println("Minimum cov: " + minCov);
            printS.println("Gene loss cutoff: " + lostCT);
            printS.println("Coverage categories: " + covCatSdef);
            printS.println();
            printS.println("Total number of genes: " + noGenesAll);
            printS.println("Total number of genes lost: " + noGenesLost);
            printS.println("Average gene length: " + aveLenAll);
            printS.println("Average gene length, genes not lost: " + aveLenPresent);
            printS.println("Average gene length, genes lost: " + aveLenLost);
            printS.println("Average exon length: " + aveELenAll);
            printS.println("Average exon length, genes not lost: " + aveELenPresent);
            printS.println("Average exon length, genes lost: " + aveELenLost);
            printS.println("Average exon number: " + aveENumAll);
            printS.println("Average exon number, genes not lost: " + aveENumPresent);
            printS.println("Average exon number, genes lost: " + aveENumLost);
            printS.close();
        }
        catch (Exception es) {
            es.printStackTrace();
        }
        PrintWriter printL = null;
        PrintWriter printCh = null;
        try {
            printL = new PrintWriter(new FileOutputStream(String.valueOf(outPath) + "graph.csv", false));
            printCh = new PrintWriter(new FileOutputStream(String.valueOf(outPath) + "chrs.csv", false));
            printL.println("chr,id,start,end");
            printCh.println("chr,start,end,len");
            for (String s : lostList) {
                printL.println(s);
            }
            for (String s : chrInfList) {
                printCh.println(s);
            }
            printL.close();
            printCh.close();
        }
        catch (Exception es) {
            es.printStackTrace();
        }
    }

    public static SAMFileReader getBamFileReader(String bamFilePath) throws Exception {
        File bamFile = new File(bamFilePath);
        File baiFile = new File(String.valueOf(bamFile.getAbsolutePath()) + ".bai");
        SAMFileReader sam = new SAMFileReader(bamFile, baiFile, true);
        sam.setValidationStringency(SAMFileReader.ValidationStringency.SILENT);
        if (!sam.hasIndex()) {
            throw new Exception("Missing index file.");
        }
        return sam;
    }

    public static String exonsLengthsToString(List<ExonEntry> exs) {
        String s = "";
        for (ExonEntry e : exs) {
            int len = e.getEnd() - e.getStart() + 1;
            s = String.valueOf(s) + len + ";";
        }
        return s.substring(0, s.length() - 1);
    }

    public static String exonsIDsToString(List<ExonEntry> exs) {
        String i = "";
        for (ExonEntry e : exs) {
            String id = e.getID();
            i = String.valueOf(i) + id + ";";
        }
        return i.substring(0, i.length() - 1);
    }

    public static String exonsCovHorToString(List<ExonEntry> exs) {
        String i = "";
        for (ExonEntry e : exs) {
            double id = e.getFracCov();
            i = String.valueOf(i) + id + ";";
        }
        return i.substring(0, i.length() - 1);
    }

    public static String exonsCovVerToString(List<ExonEntry> exs) {
        String i = "";
        for (ExonEntry e : exs) {
            double id = e.getAveCov();
            i = String.valueOf(i) + id + ";";
        }
        return i.substring(0, i.length() - 1);
    }

    public static double exonsAveLen(List<ExonEntry> exs) {
        int totLen = 0;
        for (ExonEntry e : exs) {
            int exLen = e.getEnd() - e.getStart() + 1;
            totLen += exLen;
        }
        return (double)totLen / (double)exs.size();
    }

    public static int exonsTotLen(List<ExonEntry> exs) {
        int totLen = 0;
        for (ExonEntry e : exs) {
            int exLen = e.getEnd() - e.getStart() + 1;
            totLen += exLen;
        }
        return totLen;
    }

    public static List<Integer> getCoverage(String[] bamFiles, String bamFilesPath, String chromosome, List<String> chromInfo) {
        ArrayList<Integer> finalCoverage = null;
        String[] stringArray = bamFiles;
        int n = bamFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String bam = stringArray[n2];
            SAMFileReader samR = null;
            try {
                samR = ExonCoverage5.getBamFileReader(bamFilesPath.trim() + bam.trim());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(1);
            }
            SAMFileHeader headS = samR.getFileHeader();
            ArrayList<Integer> coverage = new ArrayList<Integer>();
            IntervalList seqIL = new IntervalList(headS);
            Interval seqI = new Interval(chromosome, 1, headS.getSequence(chromosome).getSequenceLength());
            seqIL.add(seqI);
            SamLocusIterator lItr = new SamLocusIterator(samR, seqIL, true);
            System.out.println("I'm chromosome: " + headS.getSequence(chromosome).getSequenceName() + " and I'm " + headS.getSequence(chromosome).getSequenceLength() + " bp long.");
            chromInfo.add(String.valueOf(headS.getSequence(chromosome).getSequenceName()) + "," + "1" + "," + headS.getSequence(chromosome).getSequenceLength() + "," + headS.getSequence(chromosome).getSequenceLength());
            lItr.setEmitUncoveredLoci(true);
            lItr.setSamFilters(null);
            int lastPosition = 0;
            for (SamLocusIterator.LocusInfo inf : lItr) {
                int pos = inf.getPosition();
                if (pos == lastPosition + 2) {
                    int cov = 0;
                    coverage.add(cov);
                }
                coverage.add(inf.getRecordAndPositions().size());
                lastPosition = pos;
            }
            if (lastPosition == headS.getSequence(chromosome).getSequenceLength() - 1) {
                coverage.add(0);
            }
            if (coverage.size() != headS.getSequence(chromosome).getSequenceLength()) {
                System.out.println("WARNING: coverege array size not equals what reported in the header");
            }
            if (bamFiles.length == 1) {
                finalCoverage = coverage;
            } else {
                if (finalCoverage == null) {
                    finalCoverage = new ArrayList();
                    int i = 0;
                    while (i < headS.getSequence(chromosome).getSequenceLength()) {
                        finalCoverage.add(0);
                        ++i;
                    }
                }
                int i = 0;
                while (i < coverage.size()) {
                    int cov = (Integer)finalCoverage.get(i);
                    int newCov = cov + (Integer)coverage.get(i);
                    finalCoverage.set(i, newCov);
                    ++i;
                }
            }
            lItr.close();
            samR.close();
            ++n2;
        }
        return finalCoverage;
    }
}

