/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ExCovUtils {
    @Deprecated
    public static List<GeneEntry> gatherGenesGff3NoExonsChr(BufferedReader gffReader, int chrNo, String chrName) throws IOException {
        String strLine;
        ArrayList<GeneEntry> genes = new ArrayList<GeneEntry>();
        GeneEntry currentGene = null;
        while ((strLine = gffReader.readLine()) != null) {
            String[] line;
            strLine.trim();
            if (!strLine.startsWith(String.valueOf(chrName) + chrNo) || !(line = strLine.split("\t"))[2].equalsIgnoreCase("gene")) continue;
            if (currentGene != null) {
                genes.add(currentGene);
            }
            String[] geneName_ID = line[8].split(";");
            String geneIDFull = geneName_ID[0];
            String geneID = geneIDFull.substring(geneIDFull.indexOf(61) + 1);
            String geneNameFull = geneName_ID[1];
            String geneName = geneNameFull.substring(geneNameFull.indexOf(61) + 1);
            String chromo = line[0].trim();
            Integer geneStart = Integer.parseInt(line[3]);
            Integer geneEnd = Integer.parseInt(line[4]);
            String orient = line[6];
            int or = orient.equals("+") ? 1 : (orient.equals("-") ? -1 : 0);
            currentGene = new GeneEntry(geneID, geneStart, geneEnd, or, chromo, false);
            currentGene.setName(geneID);
        }
        if (currentGene != null) {
            genes.add(currentGene);
        }
        return genes;
    }

    public static List<GeneEntry> gatherGenesGff3All(BufferedReader gffReader) throws IOException {
        String strLine;
        ArrayList<GeneEntry> genes = new ArrayList<GeneEntry>();
        GeneEntry currentGene = null;
        while ((strLine = gffReader.readLine()) != null) {
            strLine.trim();
            if (strLine.startsWith("#")) continue;
            String[] line = strLine.split("\t");
            if (line[2].equalsIgnoreCase("gene")) {
                if (currentGene != null) {
                    List<ExonEntry> exL = currentGene.getExons();
                    List<ExonEntry> exLm = ExCovUtils.mergeExons(exL);
                    currentGene.setExons(exLm);
                    genes.add(currentGene);
                }
                String[] geneName_ID = line[8].split(";");
                String geneID = "";
                String geneName = "";
                String geneAlias = "";
                String note = "";
                String[] stringArray = geneName_ID;
                int n = geneName_ID.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    if (s.trim().startsWith("ID=")) {
                        geneID = s.substring(s.indexOf(61) + 1);
                    }
                    if (s.trim().startsWith("Name=")) {
                        geneName = s.substring(s.indexOf(61) + 1);
                    }
                    if (s.trim().startsWith("Alias=")) {
                        geneAlias = s.substring(s.indexOf(61) + 1);
                    }
                    if (s.trim().startsWith("Note=")) {
                        note = s.substring(s.indexOf(61) + 1);
                    }
                    ++n2;
                }
                String chromo = line[0].trim();
                Integer geneStart = Integer.parseInt(line[3]);
                Integer geneEnd = Integer.parseInt(line[4]);
                String orient2 = line[6];
                int or = orient2.equals("+") ? 1 : (orient2.equals("-") ? -1 : 0);
                currentGene = new GeneEntry(geneID, geneStart, geneEnd, or, chromo, false);
                currentGene.setName(geneID);
                currentGene.setAlias(geneAlias);
                currentGene.setNote(note);
                continue;
            }
            if (line[2].equalsIgnoreCase("mRNA") && currentGene != null) {
                String orient = line[6];
                int or = orient.equals("+") ? 1 : (orient.equals("-") ? -1 : 0);
                String[] mName_ID = line[8].split(";");
                String mID = "";
                String mName = "";
                String mAlias = "";
                String[] or2 = mName_ID;
                int orient2 = mName_ID.length;
                int geneEnd = 0;
                while (geneEnd < orient2) {
                    String s = or2[geneEnd];
                    if (s.trim().startsWith("ID=")) {
                        mID = s.substring(s.indexOf(61) + 1);
                    }
                    if (s.trim().startsWith("Name=")) {
                        mName = s.substring(s.indexOf(61) + 1);
                    }
                    if (s.trim().startsWith("Alias=")) {
                        mAlias = s.substring(s.indexOf(61) + 1);
                    }
                    ++geneEnd;
                }
                String chromo = line[0].trim();
                Integer mRNAstart = Integer.parseInt(line[3]);
                Integer mRNAend = Integer.parseInt(line[4]);
                mRNAEntry m = new mRNAEntry(mID, mRNAstart, mRNAend, or);
                m.setName(mName);
                m.setAlias(mAlias);
                m.setChromosome(chromo);
                currentGene.addmRNA(m);
            }
            if (!line[2].equalsIgnoreCase("exon") || currentGene == null) continue;
            String[] exonInfo = line[8].split(";");
            String exonIDFull = exonInfo[0];
            String exonID = exonIDFull.substring(exonIDFull.indexOf(61) + 1);
            Integer exonStart = Integer.parseInt(line[3]);
            Integer exonEnd = Integer.parseInt(line[4]);
            ExonEntry currentExon = new ExonEntry(exonID, exonStart, exonEnd);
            if (currentGene.getExons().contains(currentExon)) continue;
            currentGene.addExon(currentExon);
        }
        if (currentGene != null) {
            List<ExonEntry> exL = currentGene.getExons();
            List<ExonEntry> exLm = ExCovUtils.mergeExons(exL);
            currentGene.setExons(exLm);
            genes.add(currentGene);
        }
        return genes;
    }

    @Deprecated
    public static List<GeneEntry> gatherGenesGff3AllSNAP(BufferedReader gffReader) throws IOException {
        String strLine;
        ArrayList<GeneEntry> genes = new ArrayList<GeneEntry>();
        String currentGene = null;
        int geneStart = 0;
        String geneID = "";
        ArrayList<ExonEntry> exons = null;
        while ((strLine = gffReader.readLine()) != null) {
            int end;
            int st;
            strLine.trim();
            if (strLine.startsWith("#")) continue;
            String[] line = strLine.split("\t");
            if (line[2].equalsIgnoreCase("Esngl")) {
                st = Integer.parseInt(line[3].trim());
                end = Integer.parseInt(line[4].trim());
                String name = line[8].trim();
                String strand = line[6].trim();
                int s = 0;
                if (strand.equalsIgnoreCase("+")) {
                    s = 1;
                }
                if (strand.equalsIgnoreCase("-")) {
                    s = -1;
                }
                String gID = name;
                GeneEntry esngl = new GeneEntry(gID, st, end);
                esngl.setStrand(s);
                esngl.setChromosme(line[0].trim());
                ArrayList<ExonEntry> ex = new ArrayList<ExonEntry>();
                ex.add(new ExonEntry(name, st, end));
                esngl.setExons(ex);
                genes.add(esngl);
                continue;
            }
            if (line[2].equalsIgnoreCase("Einit")) {
                geneStart = Integer.parseInt(line[3].trim());
                if (line[6].trim().equalsIgnoreCase("-")) {
                    geneStart = Integer.parseInt(line[4].trim());
                }
                geneID = line[8];
                exons = new ArrayList<ExonEntry>();
                currentGene = geneID;
                st = Integer.parseInt(line[3].trim());
                end = Integer.parseInt(line[4].trim());
                String name = line[8].trim();
                exons.add(new ExonEntry(name, st, end));
                continue;
            }
            if (line[2].equalsIgnoreCase("exon") && currentGene != null) {
                st = Integer.parseInt(line[3].trim());
                end = Integer.parseInt(line[4].trim());
                String name = line[8].trim();
                exons.add(new ExonEntry(name, st, end));
                continue;
            }
            if (!line[2].equalsIgnoreCase("Eterm") || currentGene == null) continue;
            st = Integer.parseInt(line[3].trim());
            end = Integer.parseInt(line[4].trim());
            int geneEnd = Integer.parseInt(line[4].trim());
            if (line[6].trim().equalsIgnoreCase("-")) {
                geneEnd = Integer.parseInt(line[3].trim());
            }
            String name = line[8].trim();
            exons.add(new ExonEntry(name, st, end));
            String chrom = line[0].trim();
            GeneEntry g = null;
            String strand = line[6].trim();
            int s = 0;
            if (strand.equalsIgnoreCase("+")) {
                s = 1;
            }
            if (strand.equalsIgnoreCase("-")) {
                s = -1;
            }
            g = geneEnd < geneStart ? new GeneEntry(geneID, geneEnd, geneStart) : new GeneEntry(geneID, geneStart, end);
            g.setChromosme(chrom);
            g.setExons(exons);
            g.setStrand(s);
            genes.add(g);
            if (g.getStart() == 0 && g.getEnd() == 2119471) {
                System.out.println(strLine);
            }
            geneStart = 0;
            geneID = "";
            currentGene = null;
        }
        return genes;
    }

    public static void checkGenesUseExons(List<Integer> coverage, List<GeneEntry> geneList, int neededCov) {
        System.out.println("Gene list size is: " + geneList.size());
        for (GeneEntry g : geneList) {
            int genePosCovered = 0;
            int geneLength = 0;
            int totCoverageG = 0;
            int j = g.getStart() - 1;
            while (j < g.getEnd()) {
                if (coverage.get(j) >= neededCov) {
                    ++genePosCovered;
                    totCoverageG += coverage.get(j).intValue();
                }
                ++geneLength;
                ++j;
            }
            double covF = (double)genePosCovered / (double)geneLength;
            g.setCovFrac(covF);
            double aveCovG = genePosCovered != 0 ? (double)totCoverageG / (double)genePosCovered : 0.0;
            g.setAveGeneCov(aveCovG);
            int exonsLength = 0;
            int exonsPosCovered = 0;
            int totCoverage = 0;
            if (g.getExons() == null || g.getExons().size() == 0) continue;
            List<ExonEntry> geneExons = g.getExons();
            Collections.sort(geneExons, new ExonEntryComparator());
            for (ExonEntry ex : geneExons) {
                int exonSize = 0;
                int exonCov = 0;
                int exonCovTot = 0;
                int i = ex.getStart() - 1;
                while (i < ex.getEnd()) {
                    if (coverage.get(i) >= neededCov) {
                        ++exonsPosCovered;
                        totCoverage += coverage.get(i).intValue();
                        exonCovTot += coverage.get(i).intValue();
                        ++exonCov;
                    }
                    ++exonsLength;
                    ++exonSize;
                    ++i;
                }
                ex.setFracCov((double)exonCov / (double)exonSize);
                ex.setAveCov((double)exonCovTot / (double)exonSize);
            }
            if (exonsLength == 0) continue;
            double covFrac = (double)exonsPosCovered / (double)exonsLength;
            if (exonsPosCovered == 0) {
                g.setAveExonsCov(0.0);
            } else {
                double aveCov = (double)totCoverage / (double)exonsPosCovered;
                g.setAveExonsCov(aveCov);
            }
            g.setFracExonsCov(covFrac);
        }
    }

    @Deprecated
    public static void checkGenesUseCDS(List<Integer> coverage, List<GeneEntry> geneList, int neededCov, double fracExonCov) {
        System.out.println("Gene list size is: " + geneList.size());
        for (GeneEntry g : geneList) {
            int CDSLength = 0;
            int CDSPosCovered = 0;
            if (g.getCDS() == null || g.getCDS().size() == 0) continue;
            List<CDSEntry> cdsOverlap = g.getCDS();
            for (CDSEntry c : cdsOverlap) {
                int i = c.getStart() - 1;
                while (i < c.getEnd()) {
                    if (coverage.get(i) >= neededCov) {
                        ++CDSPosCovered;
                    }
                    ++CDSLength;
                    ++i;
                }
            }
            for (CDSEntry c : cdsOverlap) {
                System.out.println(String.valueOf(c.getID()) + " " + c.getStart() + " " + c.getEnd());
            }
            System.out.println(CDSLength);
            System.out.println(CDSPosCovered);
            if (CDSLength == 0) continue;
            double covFrac = (double)CDSPosCovered / (double)CDSLength;
            g.setFracCDSCov(covFrac);
            System.out.println(covFrac);
            if (!(covFrac >= fracExonCov)) continue;
            g.setCovered(true);
        }
    }

    @Deprecated
    public static void checkGenes(List<Integer> coverage, List<GeneEntry> geneList, int neededCov) {
        System.out.println("Gene list size is: " + geneList.size());
        block0: for (GeneEntry g : geneList) {
            int start = g.getStart();
            int end = g.getEnd();
            int covered = 0;
            int i = start - 1;
            while (i < end) {
                covered = coverage.get(i) > 200 ? ++covered : 0;
                if (covered == neededCov) {
                    g.setCovered(true);
                    g.setCovStart(i - neededCov);
                    continue block0;
                }
                ++i;
            }
        }
    }

    public static List<GeneEntry> getAllGenesGff3(String pathToGff, boolean isSNAP) throws IOException {
        FileInputStream g1 = new FileInputStream(pathToGff);
        DataInputStream g2 = new DataInputStream(g1);
        BufferedReader g3 = new BufferedReader(new InputStreamReader(g2));
        if (isSNAP) {
            return ExCovUtils.gatherGenesGff3AllSNAP(g3);
        }
        return ExCovUtils.gatherGenesGff3All(g3);
    }

    public static Map<String, List<GeneEntry>> genesListToMap(List<GeneEntry> genes) {
        LinkedHashMap<String, List<GeneEntry>> genesInChr = new LinkedHashMap<String, List<GeneEntry>>();
        for (GeneEntry g : genes) {
            if (genesInChr.containsKey(g.getChromosome())) {
                ((List)genesInChr.get(g.getChromosome())).add(g);
                continue;
            }
            genesInChr.put(g.getChromosome(), new ArrayList());
            ((List)genesInChr.get(g.getChromosome())).add(g);
        }
        return genesInChr;
    }

    public static List<ExonEntry> mergeExons(List<ExonEntry> eList) {
        ArrayList<ExonEntry> eListM = new ArrayList<ExonEntry>();
        Collections.sort(eList, new ExonEntryComparator());
        eListM.add(0, eList.get(0));
        int i = 1;
        while (i < eList.size()) {
            if (eList.get(i).getStart() <= ((ExonEntry)eListM.get(eListM.size() - 1)).getEnd()) {
                ExonEntry curr = (ExonEntry)eListM.get(eListM.size() - 1);
                if (eList.get(i).getEnd() > curr.getEnd()) {
                    curr.setEnd(eList.get(i).getEnd());
                }
                curr.setID(String.valueOf(curr.getID()) + "_" + eList.get(i).getID());
            } else {
                eListM.add(eList.get(i));
            }
            ++i;
        }
        return eListM;
    }
}

